@extends('layouts.app')

@section('content')
@extends('ventas.menu')

<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('ventas.dashboard') }}">Orden de Producción</a></li>
            <li class="breadcrumb-item active" aria-current="page">Nueva</li>
          </ol>
        </nav>
        <form action="{{ route('ventas.guardar_op') }}" method="POST">
          @csrf
          <input type="submit" href="{{route('ventas.cliente')}}" class="botonColor" value="Solicitar autorización" />
      </div>
      <hr>
    </div>
</div>

<div id="contenedor_contenido" class="container-fluid px-lg-5">
  <div class="row">
    <div class="col-md-12">
      <h2>Orden de Produción</h2>
    </div>
    <div class="col-md-12">
     
        <div class="row">
          <div class="col-md-6">
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Es para inventario</label>
              <div class="col-sm-8">
                <input class="form-check-input" type="checkbox" id="gridCheck" name="inventario" value="1">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cliente</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" value="{{$cotizacion->cliente->nombre}}" placeholder="">
                <input type="hidden" class="form-control-plaintext" name="id_cliente" value="{{$cotizacion->cliente->id}}">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Producto</label>
              <div class="col-sm-8">
                <input type="text" title="{{$cotizacion_producto->producto->nombre}}"  readonly class="form-control-plaintext" value="{{$cotizacion_producto->producto->nombre}}" placeholder="">
                <input type="hidden" class="form-control-plaintext" name="id_producto" value="{{$cotizacion_producto->producto->id}}">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Cantidades para producir</label>
              <div class="col-sm-8">
                <input type="text" id="cantidad" readonly class="form-control-plaintext" name="cantidad" value="{{$cotizacion_producto->cantidad}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Unidad de medida</label>
              <div class="col-sm-8">
                <input type="text" id="cantidad" readonly class="form-control-plaintext" name="id_medida" value="{{$cotizacion_producto->producto->medida->nombre}}" placeholder="">
              </div>
            </div>
            <!--  
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Fecha Prevista:</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext daterange-single" name="fecha_prevista" value="" placeholder="">
              </div>
            </div>
            -->
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Lista de materiales</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" name="lista_materiales" value="" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Condiciones de entrega</label>
              <div class="col-sm-8">
                <textarea class="form-control" name="condiciones_entrega" id="" cols="30" rows="4" required readonly>{{$cotizacion->condiciones_entrega}}</textarea>
              </div>
            </div>
            
          </div>


          <div class="col-md-6">

            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Vendedor</label>
              <div class="col-sm-8">
                <input type="text" readonly class="form-control-plaintext" value="{{$cotizacion->cliente->info_ejecutivo->name}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número de cotización</label>
              <div class="col-sm-8">
                <input type="text" class="form-control-plaintext" value="CO{{$idCotizacionProducto}}" placeholder="">
                <input type="hidden" name="id_cotizacion" value="{{$cotizacion->id}}">
                <input type="hidden" name="id_cotizacion_producto" value="{{$idCotizacionProducto}}">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Número de orden compra</label>
              <div class="col-sm-8">
                <input type="text" class="form-control-plaintext" name="numero_oc" value="" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">kgs por Millar</label>
              <div class="col-sm-8">
                <input id="kgs_millar" name="kgs_millar" type="text" onchange="materialProcesar(this)" class="form-control-plaintext" value="{{$cotizacion_producto->producto->factor_conversion_kilos??0}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Kgs a Procesar</label>
              <div class="col-sm-8">
                <input type="text" id="kgProcesar" name="kgs_procesar" class="form-control-plaintext" value="0" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Micras</label>
              <div class="col-sm-8">
                <input type="text"  class="form-control-plaintext" name="micras" value="{{$cotizacion_producto->producto->micras??0}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Caracteristicas</label>
              <div class="col-sm-8">
                <input type="text"  class="form-control-plaintext" name="caracteristicas" value="{{$cotizacion_producto->producto->tipos??0}}" placeholder="">
              </div>
            </div>
            <div class="form-group row">
              <label for="" class="col-sm-4 col-form-label">Observaciones</label>
              <div class="col-sm-8">
                <input type="text"  class="form-control-plaintext" name="observaciones" value="" placeholder="">
              </div>
            </div>
          </div>
        </div>
        
      </form>

    </div>
  </div>
</div>
<script>
  var kgs_millar=document.getElementById('kgs_millar');
  materialProcesar(kgs_millar)

  function nuevaFila(){
    var row = document.getElementsByClassName("producto"); // find row to copy
    console.log(row);
    var table = document.getElementById("contenedorProductos"); // find table to append to
    var clone = row[0].cloneNode(true); // copy children too
    table.appendChild(clone); // add new row to end of table
  }
  function materialProcesar(element){
    
    var cantidad=document.getElementById('cantidad').value;
    var kgMillar=parseFloat(element.value);

    var total=parseFloat(kgMillar)*parseFloat(cantidad);
    document.getElementById('kgProcesar').value=total;
  }
</script>
@endsection
