@extends('layouts.app')

@section('content')
    @extends('ventas.menu')

    <div id="contenedor-dashboard" class="container-fluid ">
        @if (in_array(auth()->user()->rol->id, [1]))
            <div class="row ">
                <div class="col-md-12">
                    <h2>Clientes</h2>
                    <a type="button" href="{{ route('ventas.cliente') }}" class="botonColor">Nuevo</a>
                </div>
            </div>
        @endif
    </div>
    <br>
    <table id="example" class="display" style="width:100%">
        <thead>
            <tr>
                <td>ID</td>
                <td>NOMBRE</td>
                <td>NIT</td>
                <td>DPI</td>
                <td>CORREO</td>
                <td>REFERENCIA</td>
                <td>CREDITO</td>
                <td>EJECUTIVO</td>
                <td>Ultima Actualizacion</td>
                <td>ACCIÓN</td>
            </tr>
        </thead>
        <tbody>
            @php
                $dias_credito_cliente = [
                    1 => 'Contado',
                    2 => '15 dias',
                    3 => '30 días',
                    4 => '45 días',
                    5 => '60 días',
                    6 => '8 días',
                ];
            @endphp
            @foreach ($clientes as $cliente)
                <tr>
                    <td>{{ $cliente['id'] }}</td>
                    <td><a href="{{ route('ventas.editar_cliente', $cliente['id']) }}"
                            target="_blank">{{ $cliente['nombre'] }}</a></td>
                    <td>{{ $cliente['nit'] }}</td>
                    <td>{{ $cliente['dpi'] }}</td>
                    <td>{{ $cliente['correo_electronico'] }}</td>
                    <td>{{ $cliente['referencia'] }}</td>
                    <td>
                        {{ $dias_credito_cliente[$cliente['condiciones_pago']] ?? 'No Disponible' }}
                    </td>
                    <td>{{ $cliente->info_ejecutivo['name'] ?? '' }}</td>
                    <td>{{ $cliente['updated_at']->format('d/m/Y') }}</td>
                    <td>
                        @if (in_array(auth()->user()->rol->id, [1]))
                            <a href="{{ route('ventas.editar_cliente', $cliente['id']) }}" target="_blank"><i
                                    class="fas far fa-edit"></i></a>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
