@extends('layouts.app')

@section('content')
    @extends('contabilidad.menu')
    <style>
        @media (max-width: 768px) {
            #contenedor_interno {
                padding-top: 150px !important;
            }
        }

        @media (min-width: 769px) {
            #contenedor_interno {
                padding-top: 0 !important;
            }
        }
    </style>
    <form action="{{ route('contabilidad.guardar_recibo_caja') }}" method="POST" onkeydown="return event.key != 'Enter';"
        enctype="multipart/form-data" id="formEnviar">
        @csrf
        <div id="contenedor_interno" class="container-fluid">
            <div class="row ">
                <div class="col-md-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('contabilidad.dashboard_recibos') }}">Recibo de
                                    caja</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Nuevo</li>
                        </ol>
                    </nav>
                    <button class="botonColor" id="botonEnviar">Guardar Recibo de Caja</button>
                </div>
                <hr>
            </div>
        </div>

        <div id="contenedor_contenido" class="container-fluid px-lg-5">
            <div class="row">
                <div class="col-md-12">
                    <h2>Recibo de Caja.</h2>
                </div>
                <div class="col-md-12">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Cliente</label>
                                <div class="col-sm-8">
                                    <p>{{ $facturas[0]->cliente->nombre }}</p>
                                    <input type="hidden" name="id_cliente" value="{{ $facturas[0]->id_cliente }}">

                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Nit</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext" id="nit"
                                        value="{{ $facturas[0]->cliente->nit }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Dirección</label>
                                <div class="col-sm-8">
                                    <p>{{ $facturas[0]->cliente->direccion }}</p>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Moneda</label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="id_moneda" id="exampleFormControlSelect1">
                                        <option {{ $facturas[0]->cliente->id_moneda == 1 ? 'selected' : '' }}
                                            value="1">Q</option>
                                        <option {{ $facturas[0]->cliente->id_moneda == 2 ? 'selected' : '' }}
                                            value="2">$</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Fecha ingreso:</label>
                                <div class="col-sm-8">
                                    <input type="text" readonly class="form-control-plaintext daterange-single"
                                        name="fecha_ingreso" value="" placeholder="">
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6">

                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Condiciones de pago</label>
                                <div class="col-sm-8">
                                    @if ($facturas[0]->cliente->condiciones_pago == 1)
                                        <p>Contado</p>
                                    @endif
                                    @if ($facturas[0]->cliente->condiciones_pago == 6)
                                        <p>8 días</p>
                                    @endif
                                    @if ($facturas[0]->cliente->condiciones_pago == 2)
                                        <p>15 días</p>
                                    @endif
                                    @if ($facturas[0]->cliente->condiciones_pago == 3)
                                        <p>30 días</p>
                                    @endif
                                    @if ($facturas[0]->cliente->condiciones_pago == 4)
                                        <p>45 días</p>
                                    @endif
                                    @if ($facturas[0]->cliente->condiciones_pago == 5)
                                        <p>60 días</p>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Régimen fiscal
                                </label>
                                <div class="col-sm-8">
                                    @if ($facturas[0]->cliente->tipo_regimen == 1)
                                        <p>Ninguno</p>
                                    @endif
                                    @if ($facturas[0]->cliente->tipo_regimen == 2)
                                        <p>Decreto régimen 2989</p>
                                    @endif
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Número Recibo Caja</label>
                                <div class="col-sm-8">
                                    <input type="number" name="numero_recibo_caja" class="form-control-plaintext"
                                        value="" placeholder="" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Imagen Recibo de caja</label>
                                <div class="col-sm-8">
                                    <input type="file" name="imagen_recibo" class="form-control-plaintext"
                                        accept="image/png, image/gif, image/jpeg">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Concepto del recibo caja</label>
                                <div class="col-sm-8">
                                    <input type="text" name="observacion_rc" class="form-control-plaintext"
                                        value="" placeholder="" required>
                                </div>
                            </div>
                            {{-- <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Saldo a favor</label>
                                <div class="col-sm-8">
                                    <input type="text" id="saldo_favor" readonly name="saldo_favor"
                                        class="form-control-plaintext" value="0" placeholder="">
                                </div>
                            </div> --}}
                        </div>
                    </div>
                    <!-- Productos -->
                    <div class="row">
                        <div class="col-md-12">
                            <ul class="nav nav-tabs" id="myTab">
                                <li class="nav-item">
                                    <a href="#home" class="nav-link" data-toggle="tab">Lista del pedido</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade" id="home">
                                    <table id="table_recibo" class="table">
                                        <thead>
                                            <tr>
                                                <th scope="col">ID</th>
                                                <th scope="col">Factura</th>
                                                <th scope="col">Saldo</th>
                                                <th scope="col">Cheque No / Retención</th>
                                                <th scope="col">Cheque Q</th>
                                                <th scope="col">Efectivo</th>
                                                <th scope="col">Valor Retención</th>
                                                <th scope="col">Total</th>
                                            </tr>
                                        </thead>
                                        <tbody id="contenedorProductos">
                                            @foreach ($facturas as $factura)
                                                <tr class="items_recibo_caja">
                                                    <input type="hidden" name="factura[]" value="{{ $factura->id }}">
                                                    <input type="hidden" name="total_factura[]"
                                                        value="{{ $factura->total - $factura->abono }}">
                                                    <input type="hidden" name="factura_sat[]"
                                                        value="{{ $factura->no_sat }}">
                                                    <td>
                                                        <p>{{ $factura->id }}</p>
                                                    </td>
                                                    <td>
                                                        <p>{{ $factura->no_sat }}</p>
                                                    </td>
                                                    <td>
                                                        <p class="saldo">
                                                            {{ number_format($factura->total - $factura->abono, 2, '.', ',') }}
                                                        </p>
                                                    </td>
                                                    <td><input type="text" name="cheques[]"></td>
                                                    <td><input type="" onchange="calcularSubTotal2(this)"
                                                            class="cheque monto" name="chequesq[]"
                                                            data_saldo="{{ $factura->total - $factura->abono }}"
                                                            value="0"></td>
                                                    <td><input type="" onchange="calcularSubTotal2(this)"
                                                            class="efectivo monto" name="efectivo[]"
                                                            data_saldo="{{ $factura->total - $factura->abono }}"
                                                            value="0"></td>
                                                    <td><input type="" onchange="calcularSubTotal2(this)"
                                                            class="retencion" name="retencion[]"
                                                            data_saldo="{{ $factura->total - $factura->abono }}"
                                                            value="0"></td>
                                                    <td class="total"><input type="tex" class="total_factura"
                                                            name="total[]" step="any" readonly value="0"></td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <hr>
                                    <div class="total">
                                        <p>TOTAL: Q <input id="totalTotal" name="total_total" type="text" readonly
                                                value="0"></p>
                                    </div>

                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </div>
    </form>
    <script>
        function calcularSubTotal2(elemento) {
            // validarMontoPagar();
            var padre = elemento.parentElement.parentElement;
            var cheque = parseFloat($(padre).find('.cheque').val());
            var efectivo = parseFloat(padre.getElementsByClassName('efectivo')[0].value);
            var retencion = parseFloat($(padre).find('.retencion').val());
            var totalTotal = cheque + efectivo + retencion;
            var saldo = parseFloat($(elemento).attr('data_saldo')).toFixed(2);
            var total_saldo = totalTotal - saldo;
            if (totalTotal < 0) {
                alert('No se puede ingresar cantidades negativas');
                $(elemento).val(0);
                return false;
            }
            if (totalTotal > saldo) {
                alert(
                    'El monto a pagar no puede ser mayor al saldo, para agregar un saldo a favor, registre un recibo de caja por separado.');
                $(elemento).val(saldo);
                padre.getElementsByClassName('total_factura')[0].value = saldo;
            } else {
                padre.getElementsByClassName('total_factura')[0].value = totalTotal.toFixed(2);
                document.getElementById('totalTotal').value = totalTotal.toFixed(2);
            }
            var total = 0;
            $('.total_factura').each(function() {
                total = total + parseFloat($(this).val());
            })
            document.getElementById('totalTotal').value = total.toFixed(2);
        }

        $("#formEnviar").submit(function(event) {
            document.getElementById('botonEnviar').disabled = true;
        });


        // function validarMontoPagar() {
        //     let saldoTotal = Array.from(document.querySelectorAll('.saldo')).reduce(function(total, elemento) {
        //         return total + parseFloat(elemento.innerText);
        //     }, 0.0);

        //     let montoTotal = Array.from(document.querySelectorAll('.monto')).reduce(function(total, elemento) {
        //         return total + parseFloat(elemento.value);
        //     }, 0.0);
        //     console.log(saldoTotal);
        //     console.log(montoTotal);

        //     montoTotal > saldoTotal ? alert('El monto a pagar no puede ser mayor al saldo') : '';
        // }
    </script>
@endsection
