@extends('layouts.app')
@extends('contabilidad.menu')

@section('content')
<style>
  .form-check{
    display: inline-block;
    top: -15px;
    left: 13px;
  }
</style>
<div class="container date-consult">
    <div class="row">
        <div class="md-col-4 my-4">
            <form action="{{ route('contabilidad.canceladas') }}" method="POST">
                @csrf
                <div class="d-flex flex-column justify-content-center">
                    <div class="d-flex justify-content-center align-items-center">
                        <p class="font-weight-bolder text-uppercase">Fecha Inicio: <input class="date-picker"
                                type="date" name="fechaInicio" id="datepicker"></p>
                        <p class="font-weight-bolder text-uppercase">Fecha Final: <input class="date-picker"
                                type="date" name="fechaFin" id="datepicker2"></p>
                    </div>
                    <div class="d-flex">
                        <div class="d-flex justify-content-center align-items-center">
                            <div>
                                <button type="submit" class="btn btn-dark mx-auto">Consultar</button>
                            </div>
                            @if (isset($fechaInicio) && isset($fechaFin))
                            <div class="d-flex">
                              <p class="blockquote mx-2">Fecha consultada</p>
                              <p class="blockquote"> del  <strong>{{ $fechaInicio }}  </strong></p>
                              <p class="blockquote">- al -<strong>{{ $fechaFin }} </strong></p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
  </div>
<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>facturas Canceladas</h2>

      
      <a type="button" onclick="cancelado()" class="botonColorNaranja">Cancelado</a>
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <table id="example14" class="display" style="width:100%">
      <thead>
        <tr>
          <td>Tipo</td>
          <td>Fecha</td>
          <td>Cliente</td>
          <td>Cantidad</td>
          <td>Producto</td>
          <td>Precio</td>
          <td>Total</td>
          <td>Documento NC/ND</td>
          <td>Recibo</td>
          <td>SAT</td>
        </tr>
      </thead>
      <tbody>      
        @foreach ($salidasAlmacen as $op)
          <tr>
            <td>{{$op->id}}</td>
            <td>{{date("d/m/Y h:i:s", strtotime($op->created_at))}}</td>
            <td>{{$op->cliente->nombre??''}}</td>
            <td>{{$op->cantidad}}</td>
            <td>{{$op->producto->nombre??''}}</td>
            <td>{{number_format($op->precio,2,'.',',')}}</td>
            <td>{{number_format($op->total,2,'.',',')}}</td>
            @if($op->nota)
            <td>{{number_format($op->nota->cantidad,2,'.',',')}} {{$op->nota->estatus==1?'ND':'NC'}}</td>
            @else
            <td></td>
            @endif
            <td><a href="{{ route('contabilidad.ver_recibo_caja',$op->id_recibo_caja_factura) }}" title="Ver recibo" target="_blank"><i class="fas fa-camera"></i> {{$op->recibo_caja->recibo_caja_numero??''}}</a></td>
            <td>
              @if($op->archivo_factura)
              <a href="{{ asset("/facturas/".$op->archivo_factura) }}" target='_blank' title="Ver factura"><i class="fas fa-camera"></i> {{$op->no_sat}}</a>
              @else
              {{$op->no_sat}}
              @endif
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>
<script>
  var token = '{{ csrf_token() }}';

 function cancelado(){
   document.querySelectorAll('.form-check-input').forEach(element => {
     var padre=element.parentElement.parentElement.parentElement;
     var id_factura=$(element).attr('data-id');
     if(element.checked ){
       jQuery( document ).ready(function() {
         $.ajax({
           type:'POST',
           url:'{{ route('contabilidad.cancelar_factura') }}',
           headers: {'X-CSRF-TOKEN': token},
           data:{
            id_factura:id_factura,
           },
           success:function(data){
             if(data){
               padre.remove();
               Swal.fire({
                   position: 'top-end',
                   title: "La factura cancelada",
                   showConfirmButton: false,
                   timer: 1500
               });
             }
           }
         });
       });
     }
   });
 }
</script>
<script>
$(document).ready(function() {
    var total = 0;

    $('#example14').dataTable( {
    "paging": false,
    "order":[[ 0, "desc" ]],
              dom: 'Bfrtip',
              buttons: [
                  'excel', 'print'
              ],
      drawCallback: function () {

        
      }
  });
    
});
</script>
@endsection
