@extends('layouts.app')

@section('content')
@extends('contabilidad.menu')

<div id="contenedor_interno" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('contabilidad.dashboard_facturas') }}">Cuenta Corriente</a></li>
            <li class="breadcrumb-item active" aria-current="page">Ver</li>
          </ol>
        </nav>
      </div>
      <hr>
    </div>
</div>
<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>Cuenta Corriente - {{$clientes[$id_cliente]->nombre}}</h2>
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <table id="example" class="display" style="width:100%">
      <thead>
        <tr>
          <th scope="col">ID</th>
          <th scope="col">Nombre</th>
          <th scope="col">Menos 30 días</th>
          <th scope="col">31 - 60 días</th>
          <th scope="col">61 - 90 días</th>
          <th scope="col">+90 días</th>
        </tr>
      </thead>
      <tbody>      
        @foreach ($clientes as $cliente)
          <tr>
            <td>{{$cliente->id}}</td>
            <td>{{$cliente->nombre}}</td>
            <td>
              @if ($facturas[$cliente->id]['pendientes']??0)
                @if (($fecha->diff($facturas[$cliente->id]['pendientes']->created_at))->days<=30)
                  @if ($facturas[$cliente->id]['abonos']??0)
                    {{number_format(($facturas[$cliente->id]['pendientes']->total_t-$facturas[$cliente->id]['abonos']->total_t),2,'.',',')}}
                  @else
                    {{number_format($facturas[$cliente->id]['pendientes']->total_t,2,'.',',')}}
                  @endif
                @else
                  -
                @endif
              @else
                  -
              @endif
            </td>
            <td>
              @if ($facturas[$cliente->id]['pendientes']??0)
                @if (($fecha->diff($facturas[$cliente->id]['pendientes']->created_at))->days>30 AND ($fecha->diff($facturas[$cliente->id]['pendientes']->created_at))->days<=60)
                  @if ($facturas[$cliente->id]['abonos']??0)
                    {{number_format(($facturas[$cliente->id]['pendientes']->total_t-$facturas[$cliente->id]['abonos']->total_t),2,'.',',')}}
                  @else
                    {{number_format($facturas[$cliente->id]['pendientes']->total_t,2,'.',',')}}
                  @endif
                @else
                  -
                @endif
              @else
                  -
              @endif
            </td>
            <td>
              @if ($facturas[$cliente->id]['pendientes']??0)
                @if (($fecha->diff($facturas[$cliente->id]['pendientes']->created_at))->days>60 AND ($fecha->diff($facturas[$cliente->id]['pendientes']->created_at))->days<=90)
                  @if ($facturas[$cliente->id]['abonos']??0)
                    {{number_format(($facturas[$cliente->id]['pendientes']->total_t-$facturas[$cliente->id]['abonos']->total_t),2,'.',',')}}
                  @else
                    {{number_format($facturas[$cliente->id]['pendientes']->total_t,2,'.',',')}}
                  @endif
                @else
                  -
                @endif
              @else
                  -
              @endif
            </td>
            <td>
              @if ($facturas[$cliente->id]['pendientes']??0)
                @if (($fecha->diff($facturas[$cliente->id]['pendientes']->created_at))->days>90)
                  @if ($facturas[$cliente->id]['abonos']??0)
                    {{number_format(($facturas[$cliente->id]['pendientes']->total_t-$facturas[$cliente->id]['abonos']->total_t),2,'.',',')}}
                  @else
                    {{number_format($facturas[$cliente->id]['pendientes']->total_t,2,'.',',')}}
                  @endif
                @else
                  -
                @endif
              @else
                  -
              @endif
            </td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>

@endsection
