<?php

namespace Database\Seeders;

use App\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UpdateUserPasswordsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $users = [
            'miguelangel_61@live.com' => 'lara1',
            'mazariegos.amilcar@gmail.com' => 'lara2',
            'wlemus@concisa.com.gt' => 'lara3',
            'danny2.concisa@gmail.com' => 'lara4',
            'esmeralda@concisa.com.gt' => 'lara5',
            'julia@concisa.com.gt' => 'lara6',
            'chofocast6@hotmail.com' => 'lara7',
            'marlontahuite@concisa.com.gt' => 'lara8',
            'kicas48@gmail.com' => 'lara9',
            'anylopeza3@gmail.com' => 'lara10',
            'noemi@concisa.com.gt' => 'lara11',
            'oscar06.concisa@gmail.com' => 'lara12',
        ];

        foreach ($users as $email => $newPassword) {
            User::where('email', $email)->update(['password' => Hash::make($newPassword)]);
        }
        
    }
}
