<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProductoController extends Controller
{
    public function categoriaDetalle($id)
    {
        // Obtener la categoría y su detalle de la tabla: detalle_categoria_producto
        $categorias = DB::table('productos_categorias')
            ->join('detalle_categoria_producto', 'productos_categorias.id', '=', 'detalle_categoria_producto.producto_categoria_id')
            ->select('productos_categorias.id', 'productos_categorias.nombre', 'productos_categorias.factor', 'productos_categorias.factor_costo_venta', 'productos_categorias.capas', 'productos_categorias.tipo', 'detalle_categoria_producto.nombre as detalle_nombre', 'detalle_categoria_producto.valor as detalle_valor', 'detalle_categoria_producto.tipo as detalle_tipo', 'productos_categorias.porcentaje_desperdicio')
            ->where('productos_categorias.id', $id)
            ->get();

        // Transformar la estructura de los datos
        $resultado = [];
        foreach ($categorias as $categoria) {
            if (!isset($resultado['nombre'])) {
                $resultado['nombre'] = $categoria->nombre;
                $resultado['factor'] = $categoria->factor;
                $resultado['capas'] = $categoria->capas;
                $resultado['tipo'] = $categoria->tipo;
                $resultado['porcentaje_desperdicio'] = $categoria->porcentaje_desperdicio;
                $resultado['factor_costo_venta'] = $categoria->factor_costo_venta;
                $resultado['detalles'] = [];
            }
            $resultado['detalles'][] = [
                'nombre' => $categoria->detalle_nombre,
                'valor' => $categoria->detalle_valor,
                'tipo' => $categoria->detalle_tipo
            ];
        }

        return $resultado;
    }
}
