<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
</head>

<body>
    <div id="app">
        <nav class="navbar navbar-light">

            <ul class="navbar-nav ml-auto">
                <!-- Authentication Links -->

                <li class="nav-item dropdown">
                    <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button"
                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                        {{ Auth::user()->name }}
                    </a>

                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                        <a class="dropdown-item" href="{{ route('logout') }}"
                            onclick="event.preventDefault();
                                             document.getElementById('logout-form').submit();">
                            Cerrar sesión
                        </a>

                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                    </div>
                </li>

            </ul>
        </nav>
        <div class="container">
            <div class="row">
                <img style="margin: auto" src="{{ asset('images/logo_concisa_t.png') }}" alt="">
                <div id="c_iconosDashboard" class="col-md-12">
                    @php
                        // Definir los permisos de acceso para cada módulo
                        $permisos = [
                            'ventas_gerencia' => [7, 12],
                            'ventas' => [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                            'compras' => [4, 7, 18, 12, 21, 22],
                            'inventario' => [1, 2, 3, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                            'fabricacion' => [1, 2, 4, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                            'contabilidad' => [1, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22],
                            'ajustes' => [7, 12],
                            'reportes' => [4, 7, 12, 18],
                            'rrhh' => [1, 4, 7, 12, 18, 21]
                        ];

                        // Función para verificar si el usuario tiene acceso
                        function tieneAcceso($idUsuario, $modulo, $permisos) {
                            return in_array($idUsuario, $permisos[$modulo]);
                        }
                    @endphp

                    {{-- Módulo de Ventas --}}
                    @if(tieneAcceso($usuario, 'ventas', $permisos))
                        @if(tieneAcceso($usuario, 'ventas_gerencia', $permisos))
                            <a href="{{ route('ventas.dashboard_gerencia') }}">
                                <div class="link">
                                    <img class="iconosDashboard" src="{{ asset('images/iconos/ventas.svg') }}"
                                        alt="Ventas">
                                    <p>Ventas</p>
                                </div>
                            </a>
                        @else
                            <a href="{{ route('ventas.dashboard') }}">
                                <div class="link">
                                    <img class="iconosDashboard" src="{{ asset('images/iconos/ventas.svg') }}"
                                        alt="Ventas">
                                    <p>Ventas</p>
                                </div>
                            </a>
                        @endif
                    @endif

                    {{-- Módulo de Compras --}}
                    @if(tieneAcceso($usuario, 'compras', $permisos))
                        <a href="{{ route('compras.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/compras.svg') }}"
                                    alt="Compras">
                                <p>Compras</p>
                            </div>
                        </a>
                    @endif

                    {{-- Módulo de Inventario --}}
                    @if(tieneAcceso($usuario, 'inventario', $permisos))
                        <a href="{{ route('inventario.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/inventario.svg') }}"
                                    alt="Inventario">
                                <p>Almacen</p>
                            </div>
                        </a>
                    @endif

                    {{-- Módulo de Fabricación --}}
                    @if(tieneAcceso($usuario, 'fabricacion', $permisos))
                        <a href="{{ route('fabricacion.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/fabricacion.svg') }}"
                                    alt="Fabricación">
                                <p>Fabricación</p>
                            </div>
                        </a>
                    @endif

                    {{-- Módulo de Contabilidad --}}
                    @if(tieneAcceso($usuario, 'contabilidad', $permisos))
                        <a href="{{ route('contabilidad.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/contabilidad.svg') }}"
                                    alt="Contabilidad">
                                <p>Contabilidad</p>
                            </div>
                        </a>
                    @endif

                    {{-- Módulo de Ajustes --}}
                    @if(tieneAcceso($usuario, 'ajustes', $permisos))
                        <a href="{{ route('ajustes.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/ajustes.svg') }}"
                                    alt="Ajustes">
                                <p>Ajustes</p>
                            </div>
                        </a>
                    @endif

                    {{-- Módulo de Reportes --}}
                    @if(tieneAcceso($usuario, 'reportes', $permisos))
                        <a href="{{ route('reportes.dashboard_gerencia') }}">
                            <div class="link">
                                <img style="background-color: transparent;" class="iconosDashboard"
                                    src="{{ asset('images/iconos/reportes.svg') }}" alt="Reportes">
                                <p>Reportes</p>
                            </div>
                        </a>
                    @endif

                    {{-- Módulo de Recursos Humanos --}}
                    @if(tieneAcceso($usuario, 'rrhh', $permisos))
                        <a href="{{ route('rrhh.dashboard') }}">
                            <div class="link">
                                <img style="background-color: transparent;" class="iconosDashboard"
                                    src="{{ asset('images/iconos/rh.svg') }}" alt="Recursos Humanos">
                                <p>Recursos Humanos</p>
                            </div>
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</body>

</html>
