@extends('layouts.app')
@extends('contabilidad.menu')
@section('content')
    <style>
        .form-check {
            display: inline-block;
            top: -15px;
            left: 13px;
        }

        .colorAmarillo {
            background-color: #ffc107 !important;
            font-weight: 600;
        }

        .colorAmarillo .sorting_1 {
            background-color: #ffc107 !important;
            font-weight: 600;
        }
    </style>

    <div class="container date-consult">
        <div class="row">
            <div class="col-md-8 my-4">
                <form action="{{ route('contabilidad.dashboard_retenciones') }}" method="GET">
                    <div class="d-flex flex-column justify-content-center">
                        <div class="d-flex flex-column justify-content-center align-items-center">
                            <div class="d-flex">
                                <p class="font-weight-bolder text-uppercase">Fecha Inicio: <input class="date-picker"
                                        type="date" name="fechaInicio" id="datepicker"></p>
                                <p class="font-weight-bolder text-uppercase">Fecha Final: <input class="date-picker"
                                        type="date" name="fechaFin" id="datepicker2"></p>
                            </div>
                            <div class="d-flex" style="font-size: 16px;">
                                <p class="mx-2">Mostrando registros</p>
                                <p class=""> del <strong>{{ $fechaInicio->format('d/m/Y') }}</strong></p>
                                <p class="ml-2"> al <strong>{{ $fechaFin->format('d/m/Y') }} </strong></p>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-dark mx-auto">Consultar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <br><br>
    @csrf
    <div id="contenedor-dashboard" class="container-fluid">
        {{-- <div class="col-md-12">
            <a type="button" href="{{ route('contabilidad.recibo_caja_facturas_nuevo') }}" class="botonColor">Nuevo
                Recibo</a>
            <br><br>
        </div> --}}
        <div class="row ">
            <div class="col-md-12">
                <h2>Retenciones</h2>
            </div>
        </div>
        <div class="col-md-12">
            <br>

            <table id="example2" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>ID</td>
                        <td>Fecha</td>
                        <td>Cliente</td>
                        <td>Retencion #</td>
                        {{-- <td>Anticipos</td> --}}
                        <td>
                            Facturas
                        </td>
                        <td>
                            Observaciones
                        </td>
                        <td>Tipo</td>
                        <td>Total Retencion</td>
                        <td>Acción</td>
                    </tr>
                </thead>
                <tbody>
                    <?php $total = 0; ?>
                    @foreach ($retenciones as $retencion)
                        <tr class="{{ $retencion->estadoColor }}">
                            <td>{{ $retencion->id }}</td>
                            <td>{{ date('d/m/Y h:i:s', strtotime($retencion->created_at)) }}</td>
                            <td>{{ $retencion->cliente?->nombre }}</td>

                            <td>{{ $retencion->numero }}</td>
                            {{-- <td>
                                @if ($op->saldo_favor > 0)
                                    -{{ number_format($op->saldo_favor, 2, '.', ',') }}
                                @endif
                                @if ($op->nombre_imagen_recibo)
                                    <a href="{{ asset('/recibo_caja/' . $op->nombre_imagen_recibo ?? '') }}"
                                        target='_blank'><i class="fas fa-camera"></i>
                                        {{ $op->recibo_caja_numero ?? '' }}</a>
                                @else
                                @endif
                            </td> --}}
                            <td>
                                <ul>
                                    @foreach ($retencion->facturas as $factura)
                                        <li>{{ $factura->no_sat }}</li>
                                    @endforeach
                                </ul>
                            </td>
                            <td>
                                {{ $retencion->observaciones }}
                            </td>
                            <td>
                                {{ $retencion->tipoString }}
                            </td>
                            <td>{{ number_format($retencion->monto_total, 2, '.', ',') }}</td>
                            <td>
                                {{-- <a href="{{ route('contabilidad.editar_retencion', $retencion->id) }}"
                                    title="Editar recibo"><i class="fas fa-edit"></i></a> --}}
                                @if ($retencion->estado == 1)
                                    <a href="{{ route('contabilidad.regresar_retencion', $retencion->id) }}"
                                        class="revertir_recibo" title="Revertir Retencion"><i
                                            class="fas fa-undo-alt"></i></a>
                                @endif
                                {{-- <a href="{{ route('contabilidad.imprimir_retencion', $retencion->id) }}"
                                    title="Imprimir Recibo"><i class="fas fa-print"></i></a> --}}
                                @if ($retencion->estado == 2)
                                    <a href="{{ route('contabilidad.eliminar_retencion', $retencion->id) }}"
                                        class="revertir_recibo" title="Eliminar Retencion"><i class="fas fa-trash"></i></a>
                                @endif
                            </td>
                            <?php $total += $retencion->monto_total; ?>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="">
                        <td>.TOTAL</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td id="data1">

                        </td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
    <script>
        $('#example2').DataTable({
            "order": [
                [0, "desc"]
            ],
            "paging": false,
            dom: 'Bfrtip',
            buttons: [
                'excel', 'print'
            ],

            responsive: {
                breakpoints: [{
                        name: 'desktop',
                        width: 920
                    },
                    {
                        name: 'tablet',
                        width: 768
                    },
                    {
                        name: 'fablet',
                        width: 668
                    },
                    {
                        name: 'phone',
                        width: 480
                    }
                ]
            }
        });
        $('.revertir_recibo').click(function() {
            var confirmar = confirm("Esta seguro de querer revertir la operación");
            if (confirmar) {

            } else {
                return false;
            }
        });
    </script>
@endsection
