<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RetencionFactura extends Model
{
    use SoftDeletes;

    protected $table = 'retencion_facturas';

    protected $fillable = [
        'monto',
        'factura_id',
        'retencion_id',
        'created_at',
        'updated_at',
        'deleted_at'
    ];

    public function factura()
    {
        return $this->belongsTo('App\Facturas');
    }

    public function retencion()
    {
        return $this->belongsTo('App\Retencion');
    }
}
