<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NotaDebito extends Model
{
    //
    use SoftDeletes;
    protected $table = 'nota_debito';
    protected $fillable = [
        'id_factura',
        'id_usuario',
        'id_tipo',
        'cantidad',
        'estatus',
        'observaciones',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function usuarios(){
        return $this->hasOne('App\User', 'id', 'id_usuario');
    }

    public function facturacion(){
        return $this->hasOne('App\Facturas', 'id', 'id_factura')->with('cliente');
    }


}
